/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

public class CECBit {
    protected int monitorID;
    protected long timestamp;
    protected long highPeriod;
    protected long lowPeriod;
    protected long rawData;
    protected boolean bInvalid;
    protected boolean bData;
    protected boolean bValue;
    protected boolean bStartSignal;
    protected boolean bIdlePresent;
    protected boolean bErrorSignal;

    public CECBit(int n, long l, long l2) {
        this.rawData = l2;
        this.monitorID = n;
        this.timestamp = l;
        this.highPeriod = l2 >> 20 & 0xFFFL;
        this.lowPeriod = l2 >> 8 & 0xFFFL;
        long l3 = this.highPeriod + this.lowPeriod;
        this.bInvalid = false;
        this.bData = false;
        this.bValue = false;
        this.bStartSignal = false;
        this.bIdlePresent = false;
        this.bErrorSignal = false;
        if (this.lowPeriod < 40L) {
            this.bInvalid = true;
        } else if (this.lowPeriod < 81L) {
            this.bData = true;
            this.bValue = true;
        } else if (this.lowPeriod < 130L) {
            this.bData = true;
            this.bInvalid = true;
            this.bValue = this.lowPeriod < 105L;
        } else if (this.lowPeriod < 171L) {
            this.bData = true;
            this.bValue = false;
        } else if (this.lowPeriod < 336L) {
            this.bInvalid = true;
        } else if (this.lowPeriod < 350L) {
            this.bErrorSignal = true;
        } else if (this.lowPeriod < 391L && l3 < 471L) {
            this.bStartSignal = true;
        } else if (this.lowPeriod < 384L) {
            this.bErrorSignal = true;
        } else {
            this.bInvalid = true;
        }
        if (this.bData) {
            if (l3 < 205L || l3 > 275L && l3 < 720L) {
                this.bInvalid = true;
            } else if (l3 >= 720L) {
                this.bIdlePresent = true;
            }
        }
        if (this.bErrorSignal && l3 < 720L) {
            this.bInvalid = true;
        }
    }

    public long getRawData() {
        return this.rawData;
    }

    public boolean isInvalid() {
        return this.bInvalid;
    }

    public boolean isData() {
        return this.bData;
    }

    public boolean value() {
        return this.bValue;
    }

    public boolean isStart() {
        return this.bStartSignal;
    }

    public boolean isErrorSignal() {
        return this.bErrorSignal;
    }

    public boolean containsIdle() {
        return this.bIdlePresent;
    }

    public long getHighPeriod() {
        return this.highPeriod;
    }

    public long getLowPeriod() {
        return this.lowPeriod;
    }

    public long getTotalPeriod() {
        return this.highPeriod + this.lowPeriod;
    }

    public String getPeriodString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = Float.valueOf((float)this.lowPeriod / 100.0f);
        objectArray[1] = Float.valueOf((float)this.highPeriod / 100.0f);
        objectArray[2] = this.isInvalid() ? "BAD" : "---";
        Object object = objectArray[3] = this.isData() ? " Y " : " N ";
        objectArray[4] = this.isErrorSignal() ? "ERR" : (this.isStart() ? " S " : (this.value() ? " 1 " : " 0 "));
        return String.format("%5.2f  | %5.2f  | %s | %s | %s ", objectArray);
    }

    public int getMonitorID() {
        return this.monitorID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

